/*
** Program: Clean Prover System
** Module:  LexicalCombinators (.icl)
** 
** Author:  Maarten de Mol
** Created: 11 September 2000
**
** Note: This is a variant of parser-combinators.
**       Differences:
**       - Only one parse is returned.
**       - Parser may never fail. 
**       - Always a list of results is returned.
**       - The empty list is used to denote that the input could not be parsed.
*/

implementation module 
   LexicalCombinators

import 
   StdEnv
       
// -------------------------------------------------------------------------------------------------------------------------------------------------
:: Parse input output		:== ([input], [output])
:: Parser input output		:== [input] -> Parse input output
// -------------------------------------------------------------------------------------------------------------------------------------------------

// -------------------------------------------------------------------------------------------------------------------------------------------------
Satisfy :: (input -> Bool) (input -> [output]) [input] -> Parse input output
// -------------------------------------------------------------------------------------------------------------------------------------------------
Satisfy pred f input=:[x:xs]
	| pred x					= (xs, f x)
	| otherwise					= (input, [])

// -------------------------------------------------------------------------------------------------------------------------------------------------
Symbol :: input (input -> [output]) [input] -> Parse input output | == input
// -------------------------------------------------------------------------------------------------------------------------------------------------
Symbol symbol f input=:[x:xs]
	| x == symbol				= (xs, f x)
	| otherwise					= (input, [])

// -------------------------------------------------------------------------------------------------------------------------------------------------
Succeed :: output [input] -> Parse input output
// -------------------------------------------------------------------------------------------------------------------------------------------------
Succeed output input
	= (input, [output])

// -------------------------------------------------------------------------------------------------------------------------------------------------
Token :: [input] ([input] -> [output]) [input] -> Parse input output | == input
// -------------------------------------------------------------------------------------------------------------------------------------------------
Token token f input
	# len						= length token
	| take len input == token	= (drop len input, f token)
	| otherwise					= (input, [])

/*
// -------------------------------------------------------------------------------------------------------------------------------------------------
(<&>) infixr 6 :: (Parser a b) (Parser a c) -> Parser a (b, c)
// -------------------------------------------------------------------------------------------------------------------------------------------------
(<&>) parser1 parser2
	= parser
	where
		parser xs
			=	[	(xs_after2, (result_after1, result_after2))
				\\	(xs_after1, result_after1)		<- parser1 xs
				,	(xs_after2, result_after2)		<- parser2 xs_after1
				]

// -------------------------------------------------------------------------------------------------------------------------------------------------
(<:&>) infixr 6 :: (Parser a b) (Parser a [b]) -> (Parser a [b])
// -------------------------------------------------------------------------------------------------------------------------------------------------
(<:&>) parser1 parser2
	= (parser1 <&> parser2) <@ (\(x, y) -> [x:y])

// -------------------------------------------------------------------------------------------------------------------------------------------------
(<&) infixr 6 :: (Parser a b) (Parser a c) -> Parser a b
// -------------------------------------------------------------------------------------------------------------------------------------------------
(<&) parser1 parser2
	= parser1 <&> parser2 <@ fst

// -------------------------------------------------------------------------------------------------------------------------------------------------
(&>) infixr 6 :: (Parser a b) (Parser a c) -> Parser a c
// -------------------------------------------------------------------------------------------------------------------------------------------------
(&>) parser1 parser2
	= parser1 <&> parser2 <@ snd

// -------------------------------------------------------------------------------------------------------------------------------------------------
(<|>) infixl 4 :: (Parser a b) (Parser a b) -> Parser a b
// -------------------------------------------------------------------------------------------------------------------------------------------------
(<|>) parser1 parser2
	= parser
	where
		parser xs
			= parser1 xs ++ parser2 xs

// -------------------------------------------------------------------------------------------------------------------------------------------------
(<!>) infixl 4 :: (Parser a b) (Parser a b) -> Parser a b
// -------------------------------------------------------------------------------------------------------------------------------------------------
(<!>) parser1 parser2
	= parser
	where
		parser xs
			# parses				= parser1 xs
			| isEmpty parses		= parser2 xs
			| otherwise				= parses

// -------------------------------------------------------------------------------------------------------------------------------------------------
<*> :: (Parser a b) -> Parser a [b]
// -------------------------------------------------------------------------------------------------------------------------------------------------
<*> parser
	=	    (parser <&> <*> parser)	<@ (\(x, y)	-> [x:y])
		<|> Succeed []

// -------------------------------------------------------------------------------------------------------------------------------------------------
<+> :: (Parser a b) -> Parser a [b]
// -------------------------------------------------------------------------------------------------------------------------------------------------
<+> parser
	=	    (parser <&> <*> parser)	<@ (\(x, y)	-> [x:y])
		<|> parser					<@ (\x		-> [x])

// -------------------------------------------------------------------------------------------------------------------------------------------------
(<@) infixl 5 :: (Parser a b) (b -> c) -> Parser a c
// -------------------------------------------------------------------------------------------------------------------------------------------------
(<@) parser f
	= map (\(input,output) -> (input, f output)) o parser

// -------------------------------------------------------------------------------------------------------------------------------------------------
(<:) infixl 5 :: (Parser a b) c -> Parser a c
// -------------------------------------------------------------------------------------------------------------------------------------------------
(<:) parser output
	= map (\(input,_) -> (input, output)) o parser
*/